(ns burningswell.web.modules.spots
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.spots :as spots]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.spot-list :refer [spot-list]]
            [rum.core :as rum]))

(rum/defc content < rum/static
  "Render the content of the spots page."
  [system {:keys [spots] :as page}]
  (layout
   system page
   [:div.spots__content
    (spot-list system spots)]))

(rum/defcs page < (coolant/mixin spots/page)
  "Render the spots page."
  [page system]
  (content system page))

(defmethod render-server :index [system]
  #?(:clj (->> (coolant/get system spots/page)
               (content system)
               (rum/render-html))))

(defmethod render-server :spots [system]
  #?(:clj (->> (coolant/get system spots/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :spots)
