(ns burningswell.web.event-handler
  (:require [burningswell.web.logging :as log]
            [com.stuartsierra.component :as component])
  #?(:cljs (:import [goog.events EventHandler])))

#?(:clj (defrecord EventHandler []))

(def logger
  "The logger of the current namespace."
  (log/logger "burningswell.web.event-handler"))

(defn listen
  "Register an event `handler` for events of `type` on `target`."
  [event-handler target type handler]
  #?(:cljs (.listen event-handler target (name type) handler)))

(defn event-handler
  "Return a new event handler."
  []
  (EventHandler.))

(extend-type EventHandler
  component/Lifecycle
  (start [event-handler]
    (log/info logger "Event handler successfully started.")
    event-handler)
  (stop [event-handler]
    #?(:cljs (.removeAll event-handler))
    (log/info logger "Event handler successfully stopped.")
    event-handler))
