(ns burningswell.web.components.google-maps
  (:require [goog.style :as style]
            [no.en.core :refer [format-url]]
            [om-tools.core :refer-macros [defcomponentk]]
            [om.core :as om :include-macros true]
            [sablono.core :refer-macros [html]]))

(defn- format-size
  "Translate :width and :height params into :size param."
  [params]
  (let [{:keys [width height]} params]
    (if (and width height)
      (-> (dissoc params :width :height)
          (assoc :size (str width "x" height)))
      params)))

(defn static-map-url
  "Return the static map url for `params`."
  [params]
  (format-url
   {:scheme :https
    :server-name "maps.googleapis.com"
    :uri "/maps/api/staticmap"
    :query-params (format-size params)}))

(defn load-static-map [data owner]
  (let [node (om/get-node owner)
        size (style/getSize node)]
    (->> {:center data
          :height (.-height size)
          :width (.-width size)
          :zoom 2}
         (static-map-url)
         (om/set-state! owner :src))))

(defcomponentk static-map
  [data owner state opts]
  (init-state [_]
    {:src nil
     :height (:height opts "100%")
     :width (:width opts "100%")})
  (did-mount [_]
    (load-static-map data owner))
  (render [_]
    (let [{:keys [width height src]} @state]
      (html [:img.google-map
             {:src src
              :style
              {:display "block"
               :width width
               :height height}}]))))
