(ns burningswell.web.components.password-field
  (:require [burningswell.web.components.text-field :as text-field]
            [goog.events.KeyCodes :as KeyCodes]
            [om.core :as om :include-macros true]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :as html :refer-macros [html]]))

(defcomponentk password-field
  "Return a text field input component."
  [data owner opts]
  (render [_]
    (html
     [:div {:class (text-field/class-name opts)}
      (text-field/label opts)
      (text-field/input data owner :password opts)
      (text-field/error data opts)])))
