(ns burningswell.web.new-spot-test
  (:require [burningswell.web.signin-test :as signin]
            [burningswell.web.test :refer :all]
            [burningswell.web.taxi :as taxi]
            [clojure.test :refer :all]))

(def new-spot-data
  {:name "Beliche"
   :latitude "37.0246"
   :longitude "-8.9650"})

(defn fill-new-spot-form
  "Fill the signin form."
  [system {:keys [name latitude longitude]}]
  (let [clear #(taxi/clear (:webdriver system) %)]
    (taxi/quick-fill
     (:webdriver system)
     {"input[name=name]" clear}
     {"input[name=name]" name}
     {"input[name=latitude]" clear}
     {"input[name=latitude]" latitude}
     {"input[name=longitude]" clear}
     {"input[name=longitude]" longitude})))

(defn submit-new-spot-form
  "Fill and submit the new spot form."
  [system spot]
  (fill-new-spot-form system spot)
  (taxi/submit (:webdriver system) "input[name=name]"))

(defn create-spot-error
  "Return the error message of the signin form."
  [{:keys [webdriver]} field]
  (some->> {:css (str ".new-spot__" (name field) "__error")}
           (taxi/find-element webdriver)
           (taxi/text webdriver)))

;; (deftest test-create-spot-sucess
;;   (with-webdriver-system [{:keys [webdriver] :as system} env]
;;     (signin/submit-signin-form system (:bodhi credentials))
;;     (wait-for-path webdriver "/spots")
;;     (browse-to system "/spots/new")
;;     (submit-new-spot-form system new-spot-data)
;;     (wait-for-path webdriver #"/spots/\d+")))

;; (deftest test-create-spot-failure
;;   (with-webdriver-system [{:keys [webdriver] :as system} env]
;;     (signin/submit-signin-form system (:bodhi credentials))
;;     (wait-for-path webdriver "/spots")
;;     (browse-to system "/spots/new")
;;     (testing "blank name"
;;       (->> (assoc new-spot-data :name "")
;;            (submit-new-spot-form system))
;;       (is (= (create-spot-error system :name)
;;              "Name can't be blank.")))
;;     (testing "name too short"
;;       (->> (assoc new-spot-data :name "x")
;;            (submit-new-spot-form system))
;;       (is (= (create-spot-error system :name)
;;              "Name is too short (min. 2 chars).")))
;;     (testing "name too long"
;;       (->> (assoc new-spot-data :name (apply str (repeat 65 "x")))
;;            (submit-new-spot-form system))
;;       (is (= (create-spot-error system :name)
;;              "Name is too long (max. 64 chars).")))))
