(ns burningswell.web.stores.search
  (:require [coolant.core :as coolant]))

(defn update-results
  "Update the auto-complete `results` in `state`."
  [state results]
  (assoc-in state [:results (:query state)] results))

(defn update-query
  "Update the auto-complete `query` in `state`."
  [state query]
  (assoc state :query query))

(def store
  "The search store."
  (coolant/store
   :search
   {:results {"" []}
    :query ""}
   {:search/query update-query
    :search/results update-results}))
