(ns burningswell.web.stores.auto-complete
  (:require [coolant.core :as coolant]))

(defn cancel
  "Add the request cancel `channel` to `state`."
  [state channel]
  (assoc state :cancel channel))

(defn clear
  "Clear the query and search results."
  [state]
  (assoc state :query "" :results []))

(defn results
  "Update the auto-complete `results` in `state`."
  [state results]
  (assoc state :results results))

(defn query
  "Update the auto-complete `query` in `state`."
  [state query]
  (assoc state :query query))

(def store
  "The auto complete store."
  (coolant/store
   :auto-complete
   {:cancel nil
    :results []
    :query ""}
   {:auto-complete/cancel cancel
    :auto-complete/clear clear
    :auto-complete/query query
    :auto-complete/results results}))
