(ns burningswell.web.stores.core
  (:require [burningswell.web.stores.auto-complete :as auto-complete]
            [burningswell.web.stores.countries :as countries]
            [burningswell.web.stores.country :as country]
            [burningswell.web.stores.map :as map]
            [burningswell.web.stores.page :as page]
            [burningswell.web.stores.region :as region]
            [burningswell.web.stores.regions :as regions]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.route :as route]
            [burningswell.web.stores.search :as search]
            [burningswell.web.stores.signin :as signin]
            [burningswell.web.stores.signout :as signout]
            [burningswell.web.stores.signup :as signup]
            [burningswell.web.stores.spot :as spot]
            [burningswell.web.stores.spots :as spots]
            [burningswell.web.stores.user :as user]
            [burningswell.web.stores.viewport :as viewport]
            [burningswell.web.util :as util]
            [coolant.core :as coolant]))

(defn setup-state
  "Start the Coolant component."
  [coolant config]
  #?(:cljs (some->>
            (-> config :elements :state)
            (util/read-transit-element)
            (vswap! coolant assoc :state)))
  coolant)

(defn coolant [& [config]]
  (-> (coolant/core
       [auto-complete/store
        countries/store
        country/store
        map/store
        page/store
        region/store
        regions/store
        resources/store
        route/store
        search/store
        signin/store
        signout/store
        signup/store
        spot/store
        spots/store
        user/store
        viewport/store])
      (setup-state config)))
