(ns burningswell.web.mixins.shake
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [cljs.core.async :refer [timeout]]
            [goog.dom.classes :as classes]
            [om.core :as om]
            [om-tools.mixin :refer-macros [defmixin]]))

(defn shake!
  "Shake the component."
  [owner]
  (when-not (om/get-state owner ::shake)
    (om/set-state! owner ::shake true)
    (go (<! (timeout 1000))
        (om/set-state! owner ::shake false))))

(defmixin shake
  "A mixin to shake components."
  (did-update [owner prev-props prev-state]
    (let [node (om/get-node owner)
          class (om/get-state owner :class)]
      (classes/enable
       node (str class "--shake")
       (om/get-state owner ::shake)))))
