(ns burningswell.web.taxi
  (:require [again.core :as again]
            [clj-webdriver.taxi :as taxi]))

(def exponential-backoff-strategy
  (again/max-duration
   10000
   (again/max-retries
    10
    (again/randomize-strategy
     0.5
     (again/multiplicative-strategy 500 1.5)))))

(defn quick-fill* [driver & query-action-maps]
  (binding [taxi/*driver* driver]
    (doall (apply taxi/quick-fill query-action-maps))))

(defn find-text*
  "Return the region headline."
  [webdriver query]
  (some->> (taxi/find-element webdriver query)
           (taxi/text webdriver)))

(defn find-texts*
  "Find all text elements matching `query`."
  [webdriver query]
  (->> (taxi/find-elements webdriver query)
       (map #(taxi/text webdriver %))
       (doall)))

(defn wrap-retry [action]
  (fn [& args]
    (again/with-retries exponential-backoff-strategy
      (apply action args))))

(def add-cookie taxi/add-cookie)
(def current-url taxi/current-url)
(def implicit-wait taxi/implicit-wait)
(def to taxi/to)
(def wait-until taxi/wait-until)

(def clear (wrap-retry taxi/clear))
(def click (wrap-retry taxi/click))
(def find-element (wrap-retry taxi/find-element))
(def find-elements (wrap-retry taxi/find-elements))
(def input-text (wrap-retry taxi/input-text))
(def quick-fill (wrap-retry quick-fill*))
(def quick-fill-submit (wrap-retry taxi/quick-fill-submit))
(def select-by-text (wrap-retry taxi/select-by-text))
(def send-keys (wrap-retry taxi/send-keys))
(def submit (wrap-retry taxi/submit))
(def text (wrap-retry taxi/text))
(def toggle (wrap-retry taxi/toggle))
(def value (wrap-retry taxi/value))


(def find-text (wrap-retry find-text*))
(def find-texts (wrap-retry find-texts*))
