(ns burningswell.web.modules.countries
  #?(:cljs (:require-macros [cljs.core.async.macros :refer [go]]))
  (:require [burningswell.web.api :as api]
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.countries :as countries]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.country-list :refer [country-list]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.system.core :as system]
            [clojure.core.async :refer [<! #?(:clj go)]]
            [rum.core :as rum]))

(defn countries-params
  "Return the query params for the countries page."
  [system & [params]]
  (merge {:min-spots 1}
         (system/current-location-params system)
         (api/pagination system :collection params)
         params))

(defn countries
  "Fetch the countries."
  [system & [params]]
  (system/dispatch! system :page/loading true)
  (go (let [params (countries-params system params)
            {:keys [status body]} (<! (api/countries system params))]
        (case status
          200 (system/dispatch! system :countries/list body))
        (system/dispatch! system :page/loading false))))

(rum/defc content < rum/static
  "Render the content of the countries page."
  [system {:keys [countries] :as page}]
  (layout
   system page
   [:div.countries__content
    (country-list system countries)]))

(rum/defcs page < (coolant/mixin countries/page)
  "Render the countries page."
  [page system]
  (content system page))

(defmethod system/change-route :countries [system route]
  (system/route-changed system route)
  (countries system (:query-params route)))

(defmethod render-server :countries [system]
  #?(:clj (->> (coolant/get system countries/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :countries)
