(ns burningswell.web.modules.region
  #?(:cljs (:require-macros [cljs.core.async.macros :refer [go]]))
  (:require [burningswell.web.api :as api]
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.region :as region]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.system.core :as system]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.spot-list :refer [spot-list]]
            [clojure.core.async :refer [<! #?(:clj go)]]
            [rum.core :as rum]))

(defn region-spots
  "Fetch the countries."
  [system region & [params]]
  (go (let [spots (:body (<! (api/spots-in-region system region params)))]
        (system/dispatch! system :region/spots [region spots])
        (system/wave-heights-charts system spots))))

(defn region
  "Fetch the region."
  [system region]
  (system/dispatch! system :page/loading true)
  (system/dispatch! system :region/region region)
  (go (let [region (:body (<! (api/region system region)))]
        (system/dispatch! system :region/region region)
        (region-spots system region)
        (system/dispatch! system :page/loading false))))

(rum/defc content < rum/static
  "Render the content of the region page."
  [system {:keys [region spots] :as page}]
  (layout
   system page
   [:div.region__content
    (spot-list system spots)]))

(rum/defcs page < (coolant/mixin region/page)
  "Render the region page."
  [page system]
  (content system page))

(defmethod system/change-route :region [system route]
  (system/route-changed system route)
  (region system (:params route)))

(defmethod render-server :region [system]
  #?(:clj (->> (coolant/get system region/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :region)
