(ns burningswell.web.stores.signup
  "The Burning Swell signup page."
  (:require [coolant.core :as coolant]))

(def initial-form
  "The initial signup form."
  {:email nil
   :password nil
   :username nil
   :shake? false
   :submitted? false})

(defn clear-form
  "Clear the signup form."
  [state _]
  (assoc state :form initial-form :errors nil))

(defn submit-form
  "Submit the signup form."
  [state _]
  (assoc-in state [:form :submitted?] true))

(defn change-field
  "Update the form `field` and clear it's error."
  [field]
  (fn [state value]
    (assoc-in state [:form field] value)))

(defn update-errors
  "Update the `errors`."
  [state errors]
  (assoc state :errors errors))

(defn update-shake
  "Update the `shake` state."
  [state shake]
  (assoc state :shake? shake))

(def store
  "The signup store."
  (coolant/store
   :signup
   {:errors nil
    :form initial-form
    :title "Signup"}
   {:signup/clear clear-form
    :signup/email (change-field :email)
    :signup/errors update-errors
    :signup/password (change-field :password)
    :signup/username (change-field :username)
    :signup/shake update-shake
    :signup/submit submit-form}))
