(ns burningswell.web.modules.regions
  #?(:cljs (:require-macros [cljs.core.async.macros :refer [go]]))
  (:require [burningswell.web.api :as api]
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.regions :as regions]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.system.core :as system]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.region-list :refer [region-list]]
            [clojure.core.async :refer [<! #?(:clj go)]]
            [rum.core :as rum]))

(defn regions-params
  "Return the query params for the regions page."
  [system & [params]]
  (merge {:min-spots 1}
         (system/current-location-params system)
         (api/pagination system :collection)
         params))

(defn regions
  "Fetch the regions."
  [system & [params]]
  (system/dispatch! system :page/loading true)
  (go (let [params (regions-params system params)
            {:keys [status body]} (<! (api/regions system params))]
        (case status
          200 (system/dispatch! system :regions/list body))
        (system/dispatch! system :page/loading false))))

(rum/defc content < rum/static
  "Render the content of the regions page."
  [system {:keys [regions] :as page}]
  (layout
   system page
   [:div.regions__content
    (region-list system regions)]))

(rum/defcs page < (coolant/mixin regions/page)
  "Render the regions page."
  [page system]
  (content system page))

(defmethod system/change-route :regions [system route]
  (system/route-changed system route)
  (regions system (:query-params route)))

(defmethod render-server :regions [system]
  #?(:clj (->> (coolant/get system regions/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :regions)
