(ns burningswell.web.modules.spots
  #?(:cljs (:require-macros [cljs.core.async.macros :refer [go]]))
  (:require [burningswell.web.api :as api]
            [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.spots :as spots]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.system.core :as system]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.spot-list :refer [spot-list]]
            [clojure.core.async :refer [<! #?(:clj go)]]
            [rum.core :as rum]))

(defn spots-params
  "Return the query params for the spots page."
  [system & [params]]
  (merge (system/current-location-params system)
         (api/pagination system :collection)
         params))

(defn spots
  "Fetch the spots."
  [system & [params]]
  (system/dispatch! system :page/loading true)
  (go (let [params (spots-params system params)
            {:keys [status body]} (<! (api/spots system params))]
        (case status
          200 (do (system/dispatch! system :spots/list body)
                  ;; (wave-heights-charts system body)
                  ))
        (system/dispatch! system :page/loading false))))

(rum/defc content < rum/static
  "Render the content of the spots page."
  [system {:keys [spots] :as page}]
  (layout
   system page
   [:div.spots__content
    (spot-list system spots)]))

(rum/defcs page < (coolant/mixin spots/page)
  "Render the spots page."
  [page system]
  (content system page))

(defmethod system/change-route :index [system route]
  (system/route-changed system route)
  (spots system (:query-params route)))

(defmethod system/change-route :spots [system route]
  (system/route-changed system route)
  (spots system (:query-params route)))

(defmethod render-server :index [system]
  #?(:clj (->> (coolant/get system spots/page)
               (content system)
               (rum/render-html))))

(defmethod render-server :spots [system]
  #?(:clj (->> (coolant/get system spots/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :spots)
