(ns burningswell.web.stores.country
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]
            [no.en.core :refer [deep-merge]]))

(defn update-country
  "Update the current country."
  [state country]
  (assoc state :country (resources/country-path country)))

(defn update-regions
  "Update the countrys around the current country."
  [state regions]
  (assoc state :regions (map resources/region-path regions)))

(def store
  "The countrys page store."
  (coolant/store
   :country
   {:country nil
    :regions []}
   {:country/country update-country
    :country/regions update-regions}))
