(ns burningswell.web.modules.spot
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.spot :as spot]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.spot-header :refer [spot-header]]
            [burningswell.web.ui.spot-list :refer [spot-list]]
            [burningswell.web.ui.weather.table :refer [weather-table]]
            [geo.core :refer [distance-to]]
            [rum.core :as rum]))

;; (defn- spot-id [app]
;;   (some-> app :route :params :id js/parseInt))

;; (s/defn address [spot :- schemas/Spot]
;;   (if-let [address (-> spot :_embedded :address :formatted)]
;;     address
;;     (->> [(-> spot :_embedded :region :name)
;;           (-> spot :_embedded :country :name)]
;;          (remove nil? )
;;          (str/join ", "))))

(defn distance-between
  "Calculate the distance in km between `spot-1` and `spot-2`."
  [spot-1 spot-2]
  (distance-to (:location spot-1) (:location spot-2)))

(defn assoc-distance-between
  "Assoc onto `spots` the distance in km between them and `spot`."
  [spot spots]
  (map #(assoc % :distance (distance-between spot %)) spots))

;; (defn flickr-photo-url
;;   "Return the link on Flickr for `photo`."
;;   [photo]
;;   (if-let [flickr (:flickr photo)]
;;     (str "https://www.flickr.com/photos/"
;;          (-> flickr :owner :id) "/"
;;          (:id flickr))))

;; (defhtml photo-attribution
;;   "Show the Flickr photo attribution."
;;   [photo]
;;   (if-let [flickr (:flickr photo)]
;;     [:div.photo-attribution
;;      [:h4.photo-attribution__header
;;       (:title photo)]
;;      [:div.photo-attribution__footer
;;       [:a.photo-attribution__user
;;        {:href (-> flickr :owner :url)
;;         :target "_blank"}
;;        (-> flickr :owner :name)]
;;       " @ "
;;       [:a.photo-attribution__url
;;        {:href (flickr-photo-url photo)
;;         :target "_blank"}
;;        "Flickr"]]]))

;; (defhtml map-button
;;   "Render the map button."
;;   [owner spot]
;;   (when-let [location (:location spot)]
;;     [:div.spot__map-button
;;      {:on-click #(action/show-spot-header (om/get-shared owner) {:type :map})}
;;      [:paper-ripple]
;;      (->static-map (core/point->lat-lng location))]))

;; (defhtml photo-button
;;   "Render the photo button."
;;   [owner spot]
;;   (when-let [location (:location spot)]
;;     [:div.spot__photo-button
;;      {:on-click #(action/show-spot-header (om/get-shared owner) {:type :photo})}
;;      [:paper-ripple]
;;      [:img {:src (-> spot :_embedded :photo :images :tiny :url)}]]))

;; (defn header-button [owner spot header]
;;   (if (= :map (:type header))
;;     (photo-button owner spot)
;;     (map-button owner spot)))

;; (defn spot-map
;;   "Render the `spot` and `spot` around on a map."
;;   [spot spots-around]
;;   (->spot-map
;;    {:spot spot :spots spots-around}
;;    {:opts
;;     {:class "spot__map"
;;      :center (:location spot) :zoom 14}}))

;; (defhtml spot-header
;;   "Render the `spot` header."
;;   [owner spot header]
;;   (let [system (om/get-shared owner)
;;         photo (hal/embedded spot :photo)]
;;     [:div.spot__header
;;      (if (= :map (:type header))
;;        (spot-map spot [])
;;        (->image (-> spot :_embedded :photo :images :medium :url)
;;                 {:opts {:class "spot__image" :sizing "cover" :fade true}}))
;;      [:div.spot__details
;;       [:div.spot-details-inner
;;        [:h3
;;         (util/country-flag (hal/embedded spot :country))
;;         (:name spot)]
;;        (->spot-address spot {:opts {:class "spot__address"}})]]
;;      (when-not (= :map (:type header))
;;        [:div.spot__photo-details
;;         (photo-attribution (-> spot :_embedded :photo))
;;         (when (and photo (evaluate (:store (om/get-shared owner)) getter/auth-token))
;;           (->like-buttons
;;            photo
;;            {:opts
;;             {:like #(action/like-spot-photo system [spot %])
;;              :dislike #(action/dislike-spot-photo system [spot %])}}))])
;;      (header-button owner spot header)]))

;; (defcomponentk spot-card
;;   "Return a spot card component."
;;   [[:data header spot spots] owner shared]
;;   (render [_]
;;     (html
;;      [:div.spot
;;       (spot-header owner spot header)
;;       ;; (->spot-weather spot {:opts {:class "spot__weather"}})
;;       (spot-map spot spots)
;;       (->weather-table
;;        {:time (display-time spot)
;;         :weather (hal/embedded spot :weather)
;;         :time-zone (hal/embedded spot :time-zone)}
;;        {:opts {:class "spot__weather__table"}})
;;       (spots-around spot spots)])))

;; (defn- fetch-data [app owner]
;;   (when (spot-id app)
;;     (action/spot (om/get-shared owner) {:id (spot-id app)})))

;; (defcomponentk page
;;   "Return a spot page component."
;;   [owner state]
;;   (:mixins coolant-mixin)
;;   (will-mount [_]
;;     (.observe owner getter/spot-page)
;;     (fetch-data @state owner))
;;   (will-update [this next-props next-state]
;;     (when-not (= (om/get-render-state owner :route)
;;                  (om/get-state owner :route))
;;       (fetch-data @state owner)))
;;   (render [_]
;;     (when-not (empty? @state)
;;       (layout/->toolbar-page
;;        @state {:opts {:children (html [:div.spot-page (->spot-card @state)])}}))))

;; (def ^:export main ->page)
;; (module-loaded :spot)

(rum/defc spots-around < rum/static
  "Render the `spots` that are around `spot`."
  [system spot spots]
  (when-not (empty? spots)
    [:div.spot__spots-around
     [:h2.spot__spots-around-headline "Nearby Spots"]
     (spot-list system (assoc-distance-between spot spots))]))

(rum/defc spot-weather < rum/static
  "Render the weather forecast for `spot`."
  [system spot weather]
  (when-not (empty? weather)
    [:div.spot__weather
     [:h2.spot__weather-headline "Surf Forecast"]
     (weather-table weather)]))

(rum/defc content < rum/static
  "Render the content of the spot page."
  [system {:keys [spot spots photos weather] :as page}]
  (layout
   system page
   [:div.spot__content
    (spot-header system spot photos)
    [:div.spot__details
     (spot-weather system spot weather)
     (spots-around system spot spots)]]))

(rum/defcs page < (coolant/mixin spot/page)
  "Render the spot page."
  [page system]
  (content system page))

(defmethod render-server :spot [system]
  #?(:clj (->> (coolant/get system spot/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :spot)
