(ns burningswell.web.signin-test
  (:require [burningswell.web.test :refer :all]
            [burningswell.web.taxi :as taxi]
            [clojure.test :refer :all]))

(defn fill-form
  "Fill the signin form."
  [system {:keys [login password]}]
  (taxi/quick-fill
   (:webdriver system)
   {"input[name=login]" (str login)}
   {"input[name=password]" (str password)}))

(defn submit-signin-form
  "Fill and submit the signin form."
  [system credentials]
  (browse-to system "/signin")
  (fill-form system (:bodhi credentials))
  (taxi/submit (:webdriver system) "input[name=login]"))

(defn signin-error
  "Return the error message of the signin form."
  [system]
  (taxi/text (:webdriver system) ".signin__errors"))

(deftest ^:webdriver test-signin-sucess
  (with-webdriver-system [system env]
    (submit-signin-form system credentials)
    (is (wait-for-path (:webdriver system) #"/"))
    (click-route system :signout)
    (is (= (form-field-value system :login) ""))
    (is (= (form-field-value system :password) ""))))

(deftest ^:webdriver test-signin-failure
  (with-webdriver-system [system env]
    (submit-signin-form system {:login "" :password "secret"})
    (is (= (signin-error system)
           "Incorrect credentials. Try again!"))))
