(ns burningswell.web.stores.signin
  (:require [coolant.core :as coolant]))

(def initial-form
  "The initial signin form."
  {:login nil
   :password nil
   :remember-me false})

(defn clear-form
  "Clear the signin form."
  [state]
  (assoc state :form initial-form))

(defn clear-errors
  "Clear the signin form errors."
  [state]
  (assoc state :errors nil))

(defn clear-signin
  "Clear the signin form and errors."
  [state]
  (-> (clear-form state)
      (clear-errors)))

(defn change-field
  "Update the form `field` and clear it's error."
  [field & [clear-errors?]]
  (fn [state value]
    (cond-> (assoc-in state [:form field] value)
      clear-errors? (clear-errors))))

(defn update-errors
  "Update the `errors`."
  [state errors]
  (assoc state :errors errors))

(defn update-shake
  "Update the `shake` state."
  [state shake]
  (assoc state :shake? shake))

(defn submit-form
  "Submit the signin form."
  [state _]
  (assoc state :submitted? true))

(def store
  "The signin store."
  (coolant/store
   :signin
   {:errors nil
    :form initial-form
    :shake? false
    :submitted? false
    :title "Signin"}
   {:signin/clear clear-signin
    :signin/errors update-errors
    :signin/login (change-field :login true)
    :signin/password (change-field :password true)
    :signin/remember-me (change-field :remember-me)
    :signin/shake update-shake
    :signin/submit submit-form}))
