(ns burningswell.web.stores.spots
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn load-spots-start [state params]
  (-> (merge state params)
      (assoc :loading? true)))

(defn load-spots-success [state spots]
  (-> (assoc state :loading? false)
      (update :list concat (map resources/spot-path spots))))

(defn load-spots-fail [state errors]
  (assoc state :loading? false))

(def store
  "The spots page store."
  (coolant/store
   :spots
   {:list []
    :loading? false
    :title "Spots"
    :page nil}
   {:spots/load-spots-start load-spots-start
    :spots/load-spots-success load-spots-success
    :spots/load-spots-fail load-spots-fail}))
