(ns burningswell.web.ui.country-card
  (:require [burningswell.web.ui.country-headline :refer [country-headline]]
            [burningswell.web.ui.image :refer [image]]
            [rum.core :as rum]))

(rum/defc country-image < rum/static
  "Render a country image."
  [country]
  (when-let [src (-> country :_embedded :photo :images :small :url)]
    (image
     {:class "country-card__image"
      :preload true
      :sizing "cover"
      :fade true
      :src src})))

(defn country-card-key
  "Return the country list item key."
  [system country]
  (str "country-list-item-" (:id country)))

(rum/defc country-card < rum/static {:key-fn country-card-key}
  "Render the country list item."
  [system country]
  [:div.country-card
   (country-image country)
   (country-headline system country)])
