(ns burningswell.web.stores.page
  (:require [coolant.core :as coolant]))

(def breakpoints
  "The media query breakpoints."
  {:xxs 320
   :xs 400
   :s 600
   :m 840
   :l 960
   :xl 1280
   :xxl 1440})

(defn layout
  "Return the layout based on `width`."
  [{:keys [width]}]
  (when width
    (cond
      (>= width (:xxl breakpoints)) :xxl
      (>= width (:xl breakpoints)) :xl
      (>= width (:l breakpoints)) :l
      (>= width (:m breakpoints)) :m
      (>= width (:s breakpoints)) :s
      (>= width (:xs breakpoints)) :xs
      :else :xxs)))

(defn update-current-location
  "Update the current location."
  [state location]
  (assoc state :current-location location))

(defn update-layout
  "update the page layout."
  [state size]
  (assoc state :layout (layout size)))

(defn update-loading
  "Update the loading status."
  [state loading]
  (assoc state :loading loading))

(def store
  "The page store."
  (coolant/store
   :page
   {:layout nil
    :loading false}
   {:current/location update-current-location
    :page/loading update-loading
    :viewport/size update-layout}))
