(defproject burningswell/web "0.2.32"
  :description "The Burning Swell web application"
  :url "https://github.com/burningswell/web"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/api-client "0.0.51"]
                 [burningswell/config "0.1.38"]
                 [burningswell/core "0.0.46"]
                 [burningswell/geoip "0.1.0"]
                 [burningswell/pedestal "0.1.3"]
                 [burningswell/transit "0.1.2"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [ch.qos.logback/logback-core "1.1.7"]
                 [cljs-http "0.1.42"]
                 [cljsjs/google-maps "3.18-1"]
                 [cljsjs/material "1.2.1-0"]
                 [cljsjs/react "15.2.1-1"]
                 [cljsjs/react-dom "15.2.1-1"]
                 [cljsjs/react-dom-server "15.2.1-1"]
                 [com.andrewmcveigh/cljs-time "0.5.0-alpha1"]
                 [com.stuartsierra/component "0.3.1"]
                 [environ "1.1.0"]
                 [funcool/hodgepodge "0.1.4"]
                 [hal-clj "0.1.12"]
                 [hiccup "1.0.5"]
                 [noencore "0.3.3"]
                 [org.clojars.r0man/coolant "0.1.1-SNAPSHOT"]
                 [org.clojure/clojure "1.9.0-alpha14"]
                 [org.clojure/clojurescript "1.9.229"]
                 [org.clojure/core.async "0.2.395"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.clojure/tools.reader "0.10.0"]
                 [request-clj "0.3.2"]
                 [rum "0.10.7"]
                 [rum-mdl "0.2.0"]
                 [sablono "0.7.6"]]
  :plugins [[lein-cljsbuild "1.1.4"]
            [lein-environ "1.1.0"]
            [lein-shell "0.5.0"]]
  :aliases {"ci" ["do"
                  ["clean"]
                  ["test-cljs"]
                  ["test-clj"]
                  ["lint"]]
            "test-clj" ["do"
                        ["with-profile" "production" "cljsbuild" "once" "production"]
                        ["difftest"]]
            "test-cljs" ["doo" "phantom" "test" "once"]
            "lint" ["do" ["eastwood"]]}
  :clean-targets
  ^{:protect false}
  [:compile-path
   :target-path
   ".sass-cache"
   "pkg"
   "resources/public/javascripts"
   "resources/public/javascripts/burningswell.js"]
  :cljsbuild {:builds
              [{:id "dev"
                :compiler
                {:asset-path "/javascripts/dev"
                 :main burningswell.web.main
                 :optimizations :none
                 :output-dir "resources/public/javascripts/dev"
                 :output-to "resources/public/javascripts/burningswell.js"
                 :parallel-build true
                 :pretty-print false
                 :source-map true
                 :source-map-timestamp true
                 :verbose false}
                :figwheel
                {:on-jsload "burningswell.web.main/restart"}
                :source-paths ["src/clj" "src/clj-dev"]}
               {:id "devcards"
                :compiler
                {:asset-path "/javascripts/devcards"
                 :main burningswell.web.test.runner
                 :optimizations :none
                 :output-dir "resources/public/javascripts/devcards"
                 :output-to "resources/public/javascripts/burningswell.devcards.js"
                 :parallel-build true
                 :pretty-print false
                 :source-map true
                 :source-map-timestamp true
                 :verbose false}
                :figwheel {:devcards true}
                :source-paths ["src/clj" "src/clj-dev" "test/cljs"]}
               {:id "test"
                :compiler
                {:asset-path "resources/public/javascripts/test"
                 :main burningswell.web.test.runner
                 :optimizations :none
                 :output-dir "resources/public/javascripts/test"
                 :output-to "resources/public/javascripts/burningswell.test.js"
                 :parallel-build true
                 :pretty-print false
                 :source-map true
                 :source-map-timestamp true
                 :verbose false}
                :source-paths ["src/clj" "src/clj-dev" "test/cljs"]}
               {:id "production"
                :compiler
                {:asset-path "/javascripts/production"
                 :closure-defines {goog.DEBUG false}
                 :externs ["externs/diaporama.js"]
                 :main burningswell.web.main
                 :optimizations :advanced
                 :output-dir "resources/public/javascripts/production"
                 :output-to "resources/public/javascripts/burningswell.js"
                 :parallel-build true
                 :pretty-print false
                 :pseudo-names false
                 :source-map "resources/public/javascripts/burningswell.js.map"
                 :verbose false
                 :modules
                 {:cljs-base
                  {:output-to "resources/public/javascripts/burningswell.js"
                   :entries #{"burningswell.web.main"}}
                  :countries
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/countries.min.js"
                   :entries #{"burningswell.web.modules.countries"
                              "burningswell.web.getter.countries"
                              "burningswell.web.stores.countries"}}
                  :country
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/country.min.js"
                   :entries #{"burningswell.web.modules.country"
                              "burningswell.web.getter.country"
                              "burningswell.web.stores.country"}}
                  :map
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/map.min.js"
                   :entries #{"burningswell.web.modules.map"
                              "burningswell.web.getter.map"
                              "burningswell.web.stores.map"}}
                  :new-spot
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/new_spot.min.js"
                   :entries #{"burningswell.web.modules.new-spot"
                              "burningswell.web.getter.new-spot"}}
                  :region
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/region.min.js"
                   :entries #{"burningswell.web.modules.region"
                              "burningswell.web.getter.region"
                              "burningswell.web.stores.region"}}
                  :regions
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/regions.min.js"
                   :entries #{"burningswell.web.modules.regions"
                              "burningswell.web.getter.regions"
                              "burningswell.web.stores.regions"}}
                  :search
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/search.min.js"
                   :entries #{"burningswell.web.modules.search"
                              "burningswell.web.getter.search"
                              "burningswell.web.stores.search"}}
                  :settings
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/settings.min.js"
                   :entries #{"burningswell.web.modules.settings"
                              "burningswell.web.getter.settings"
                              "burningswell.web.stores.settings"}}
                  :signin
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/signin.min.js"
                   :entries #{"burningswell.web.modules.signin"
                              "burningswell.web.getter.signin"
                              "burningswell.web.stores.signin"}}
                  :signout
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/signout.min.js"
                   :entries #{"burningswell.web.modules.signout"
                              "burningswell.web.getter.signout"
                              "burningswell.web.stores.signout"}}
                  :signup
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/signup.min.js"
                   :entries #{"burningswell.web.modules.signup"
                              "burningswell.web.getter.signup"
                              "burningswell.web.stores.signup"}}
                  :spot
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/spot.min.js"
                   :entries #{"burningswell.web.modules.spot"
                              "burningswell.web.getter.spot"
                              "burningswell.web.stores.spot"}}
                  :spots
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/spots.min.js"
                   :entries #{"burningswell.web.modules.spots"
                              "burningswell.web.getter.spots"
                              "burningswell.web.stores.spots"}}
                  :welcome
                  {:output-to "resources/public/javascripts/production/burningswell/web/modules/welcome.min.js"
                   :entries #{"burningswell.web.modules.welcome"
                              "burningswell.web.getter.welcome"
                              "burningswell.web.stores.welcome"}}}}
                :source-paths ["src/clj" "src/clj-production"]}]
              :test-commands {"phantom" ["bin/test"]}}
  :main ^{:skip-aot true} burningswell.web.main
  :min-lein-version "2.0.0"
  :profiles {:dev {:dependencies [[burningswell/api "0.2.18"]
                                  [clj-webdriver "0.7.2"]
                                  [com.cemerick/piggieback "0.2.1"]
                                  [devcards "0.2.2"]
                                  [doo "0.1.7"]
                                  [figwheel-sidecar "0.5.8"]
                                  [listora/again "0.1.0"]
                                  [org.seleniumhq.selenium/selenium-java "3.0.0-beta4"]
                                  [org.seleniumhq.selenium/selenium-server "3.0.0-beta4"
                                   :exclusions [org.bouncycastle/bcpkix-jdk15on
                                                org.bouncycastle/bcprov-jdk15on]]
                                  [org.seleniumhq.selenium/selenium-remote-driver "3.0.0-beta4"
                                   :exclusions [com.google.guava/guava]]
                                  [org.clojure/tools.nrepl "0.2.12"]
                                  [reloaded.repl "0.2.3"]
                                  [xml-apis/xml-apis "1.4.01"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [lein-figwheel "0.5.8"]
                             [lein-doo "0.1.7"]
                             [listora/whitespace-linter "0.1.0"]]
                   :figwheel {:css-dirs ["resources/public/stylesheets"]
                              :http-server-root "public"
                              :server-logfile "logs/figwheel.log"}
                   :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]
                                  :init-ns user}
                   :source-paths ["dev" "src/clj" "src/clj-dev"]}
             :production {:source-paths ^:replace ["src/clj" "src/clj" "src/clj-production"]}
             :test {:source-paths ^:replace ["src/clj" "src/clj-dev" "test/clj"] ;; TODO: Needed for Figwheel
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all
                       :main burningswell.web.main
                       :prep-tasks
                       [["with-profile" "production" "cljsbuild" "once" "production"]
                        ["compile"]
                        ["shell" "gulp" "--production"]]
                       :resource-paths ["uberjar-resources"]
                       :source-paths ^:replace ["src/clj" "src/clj-production"]}}
  :source-paths ["src/clj" "test/clj"]
  :test-paths ["test/clj"]
  :test-selectors {:default (complement :webdriver)
                   :webdriver :webdriver
                   :all (constantly true)}
  :uberjar-name "burningswell-web.jar")
