(ns burningswell.web.actions-test
  (:require [burningswell.db.spots :refer [mundaka]]
            [burningswell.web.getter.countries :as countries]
            [burningswell.web.getter.regions :as regions]
            [burningswell.web.getter.spots :as spots]
            [burningswell.web.test :refer :all]
            [burningswell.web.system.core :as system]
            [clojure.core.async :refer [<!!]]
            [clojure.test :refer :all]
            [coolant.core :as coolant]))

(defn evaluate [system getter]
  (system/evaluate system getter))

(deftest test-initial-route
  (with-headless-system [system env]
    (is (= (system/current-route system) {:name :root}))))

(deftest test-change-route-signup
  (with-headless-system [system env]
    (system/change-route system {:name :signup})
    (is (= (system/current-route system) {:name :signup}))))

(deftest test-change-route-signin
  (with-headless-system [system env]
    (system/change-route system {:name :signin})
    (is (= (system/current-route system) {:name :signin}))))

(deftest test-change-route-countries
  (with-headless-system [system env]
    (<!! (system/change-route system {:name :countries}))
    (is (= (system/current-route system) {:name :countries}))
    (is (= (map :name (evaluate system countries/country-list))
           ["Indonesia" "Portugal" "Spain" "United States"]))))

(deftest test-change-route-regions
  (with-headless-system [system env]
    (<!! (system/change-route system {:name :regions}))
    (is (= (system/current-route system) {:name :regions}))
    (is (= (map :name (evaluate system regions/region-list))
           ["Bali" "Hawaii" "Lisboa" "País Vasco"]))))

(deftest test-change-route-spots
  (with-headless-system [system env]
    (let [spot (mundaka (-> system :api :db))]
      (system/change-current-location system (:location spot))
      (<!! (system/change-route system {:name :spots}))
      (is (= (system/current-route system) {:name :spots}))
      (is (= (map :name (evaluate system spots/spot-list))
             ["Mundaka"
              "Meñakoz"
              "São Lorenço"
              "Coxos"
              "Ribeira D'ilhas"
              "Crazy Left"
              "Pontina"
              "Backdoor"
              "The Reef"
              "Praia do Norte"
              "Praia do Peixe"
              "Furnas"
              "Foz do Lizandro"
              "São Julião"
              "Costa da Caparica"
              "Praia do Castello"])))))
