(ns burningswell.web.modules.new-spot
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.new-spot :as new-spot]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [rum.core :as rum]))

;; (defn map-center
;;   "Return the map center."
;;   [map]
;;   (core/lat-lng->point (.getCenter map)))

;; (defn bounding-box
;;   "Return the bounding box of the map."
;;   [map]
;;   (when-let [bounds (.getBounds map)]
;;     {:top (.lat (.getNorthEast bounds))
;;      :right (.lng (.getNorthEast bounds))
;;      :bottom (.lat (.getSouthWest bounds))
;;      :left (.lng (.getSouthWest bounds))}))

;; (defn pan-to
;;   "Pan the map of `owner` to `location`."
;;   [owner location]
;;   (when location
;;     (when-let [channel (om/get-state owner :spot-map-chan)]
;;       (async/put! channel [:pan-to location]))))

;; (defn update-location
;;   [system location]
;;   (go (action/dispatch!
;;        system :new-spot/latitude
;;        (gstring/format "%.4f" (geo/point-y location)))
;;       (action/dispatch!
;;        system :new-spot/longitude
;;        (gstring/format "%.4f" (geo/point-x location)))))

;; (defn update-bounding-box
;;   [system bounding-box]
;;   (go (action/dispatch! system :new-spot/bounding-box bounding-box)))

;; (defn update-address
;;   [system address]
;;   (go
;;     (when-let [location (-> address :selected :location)]
;;       (update-location system location))
;;     (action/dispatch! system :new-spot/address address)))

;; (defn make-spot [data]
;;   {:name (-> data :name :value)
;;    :location
;;    (geo/point
;;     4326
;;     (-> data :longitude :value js/parseFloat)
;;     (-> data :latitude :value js/parseFloat))})

;; (defn submit-spot
;;   [system data]
;;   (go (let [{:keys [status body]}
;;             (<! (api/create-spot
;;                  (:api system) (evaluate (:store system) getter/user)
;;                  (make-spot data)))]
;;         (case status
;;           201 (do (action/dispatch! system :new-spot/created body)
;;                   (action/navigate! system (hal/href body :self)))
;;           401 (action/navigate! system "/signin")
;;           422 (action/dispatch! system :new-spot/unprocessable body))
;;         (action/dispatch! system :new-spot/submitted-at (js/Date.)))))

;; (defn load-spots-in-bounding-box
;;   "Load the spots in `bounding-box` from the API."
;;   [system bounding-box]
;;   (go (let [{:keys [status body]} (<! (api/spots (:api system) bounding-box))]
;;         (case status
;;           200 (action/dispatch! system :new-spot/spots body)))))

;; (defn update-address-when-idle
;;   "Geocode the map center and change the address when the map is idle."
;;   [owner map]
;;   (when-let [center (map-center map)]
;;     (go (when-let [address (first (<! (geocoder/geocode-point center)))]
;;           (->> (assoc address :value (:formatted address))
;;                (update-address (om/get-shared owner)))))))

;; (defn update-location-when-idle
;;   "Change the location to the map center when the map is idle."
;;   [owner map]
;;   (some->> (map-center map)
;;            (update-location (om/get-shared owner))))

;; (defn update-bounding-box-when-idle
;;   "Update the bounding box when the map is idle."
;;   [owner map]
;;   (some->> (bounding-box map)
;;            (update-bounding-box (om/get-shared owner))))

;; (defn on-map-idle
;;   "Handler that gets called when the map is idle."
;;   [owner map]
;;   (update-address-when-idle owner map)
;;   (update-location-when-idle owner map)
;;   (update-bounding-box-when-idle owner map))

;; (defn bounding-box-changed?
;;   "Return true if the bounding box has changed, otherwise false."
;;   [data next-props]
;;   (not= (-> data :bounding-box)
;;         (-> next-props :bounding-box)))

;; (defn location-changed?
;;   "Return true if the location has changed, otherwise false."
;;   [data next-props]
;;   (or (not= (-> data :latitude :value)
;;             (-> next-props :latitude :value))
;;       (not= (-> data :longitude :value)
;;             (-> next-props :longitude :value))))

;; (defn location
;;   "Return the location from `data`."
;;   [data]
;;   (let [latitude (-> data :latitude :value js/parseFloat)
;;         longitude (-> data :longitude :value js/parseFloat)]
;;     (when (and (not (js/isNaN latitude))
;;                (not (js/isNaN longitude)))
;;       (geo/point 4326 longitude latitude))))

;; (defn address-field
;;   "Return a address field component."
;;   [data owner]
;;   (autocomplete/->address
;;    (-> data :address :formatted)
;;    {:opts
;;     {:class "new-spot__address"
;;      :label "Address"
;;      :name "address"
;;      :select-fn #(update-address (om/get-shared owner) %)}}))

;; (defn latitude-field
;;   "Return a latitude field component."
;;   [data owner]
;;   (let [system (om/get-shared owner)]
;;     (->text-field
;;      (-> data :latitude)
;;      {:opts
;;       {:class "new-spot__latitude"
;;        :label "Latitude"
;;        :name "latitude"
;;        :on-blur (action/on-value-change system :new-spot/latitude)
;;        :on-enter (action/on-value-change system :new-spot/latitude)}})))

;; (defn longitude-field
;;   "Return a longitude field component."
;;   [data owner]
;;   (let [system (om/get-shared owner)]
;;     (->text-field
;;      (-> data :longitude)
;;      {:opts
;;       {:class "new-spot__longitude"
;;        :label "Longitude"
;;        :name "longitude"
;;        :on-blur (action/on-value-change system :new-spot/longitude)
;;        :on-enter (action/on-value-change system :new-spot/longitude)}})))

;; (defhtml location-field
;;   "Return a location field component."
;;   [data owner]
;;   [:div.new-spot__location
;;    (latitude-field data owner)
;;    (longitude-field data owner)])

;; (defn spot-name-field
;;   "Return a spot name field component."
;;   [data owner]
;;   (->text-field
;;    (-> data :name)
;;    {:opts
;;     {:class "new-spot__name"
;;      :label "Name"
;;      :name "name"
;;      :on-change (action/on-value-change (om/get-shared owner) :new-spot/name)
;;      :placeholder "What's the name of the spot?"}}))

;; (defhtml instructions []
;;   [:p.new-spot__instructions
;;    "Where is the spot? Please center the spot on the map. Try to enter
;;    the address, city or geo location of the spot to move the map close
;;    to it. Then use the map controls to zoom in and navigate the spot
;;    exactly to the center."])

;; (defn on-submit [owner event]
;;   (submit-spot (om/get-shared owner) (om/get-props owner))
;;   (.preventDefault event))

;; (defn create-spot-button
;;   "Render the submit button."
;;   [owner]
;;   (->paper-button
;;    "Create Spot"
;;    {:opts
;;     {:class "new-spot__submit"
;;      :on-click #(on-submit owner %)}}))

;; (defn errors [data]
;;   (reduce
;;    (fn [errors k]
;;      (if-let [error (get-in data [k :error])]
;;        (assoc errors k error)
;;        errors))
;;    {} [:name :latitude :longitude]))

;; (defn shake?
;;   "Return true if the signin form should shake."
;;   [owner next-props]
;;   (and (:submitted-at next-props)
;;        (not (empty? (errors next-props)))
;;        (not= (:submitted-at next-props)
;;              (:submitted-at (om/get-props owner)))))

;; (defn shake!
;;   "Shake the signin form."
;;   [owner]
;;   (om/set-state! owner :shake true)
;;   (go (<! (timeout 1000))
;;       (om/set-state! owner :shake false)))

;; (defcomponentk new-spot-card
;;   [data owner state shared]
;;   (init-state [_]
;;     {:spot-map-chan (chan)})
;;   (will-receive-props [_ next-props]
;;     (when (shake? owner next-props)
;;       (shake! owner))
;;     (when (location-changed? data next-props)
;;       (pan-to owner (location next-props)))
;;     (when (bounding-box-changed? data next-props)
;;       (load-spots-in-bounding-box shared (:bounding-box next-props))))
;;   (render [_]
;;     (html
;;      [:div.new-spot__card
;;       {:class (if (:shake @state) "new-spot__card--shake")}

;;       [:form.new-spot__form
;;        {:on-submit #(on-submit owner %1)}
;;        (spot-name-field data owner)
;;        (instructions)
;;        [:div.new-spot__address-location
;;         (address-field data owner)
;;         (location-field data owner)]
;;        (create-spot-button owner)]

;;       (->crosshair-map
;;        {:spots (:spots data)}
;;        {:opts
;;         {:class "new-spot__map"
;;          :center (location data)
;;          :channel (:spot-map-chan @state)
;;          :on-idle #(on-map-idle owner %)}})])))

;; (defcomponentk location-card
;;   [data owner state shared]
;;   (render [_]
;;     (html
;;      [:div.new-spot
;;       (->new-spot-card data)
;;       [:div.new-spot__spots-around
;;        (->spot-list (:spots data))]])))

;; (defcomponentk page
;;   "Return the spot page component."
;;   [owner state]
;;   (:mixins coolant-mixin)
;;   (will-mount [_]
;;     (.observe owner getter/new-spot-page))
;;   (render [_]
;;     (layout/->toolbar-page
;;      @state
;;      {:opts
;;       {:children
;;        (html
;;         [:div.new-spot-page
;;          (->location-card @state)])}})))

;; (def ^:export main ->page)
;; (module-loaded :new-spot)


(rum/defc content < rum/static
  "Render the content of the new spot page."
  [system {:keys [country] :as page}]
  (layout
   system page
   [:div.new-spot__content
    "NEW SPOT"]))

(rum/defcs page < (coolant/mixin new-spot/page)
  "Render the new spot page."
  [page system]
  (content system page))

(defmethod render-server :new-spot [system]
  #?(:clj (->> (coolant/get system new-spot/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :new-spot)
