(ns burningswell.web.getter.welcome
  (:require [burningswell.web.getter.core :refer [layout]]
            [burningswell.web.stores.resources :as resources]
            [burningswell.web.stores.welcome :as welcome]
            [coolant.core :as coolant]))

(defn resource-list [store key]
  (coolant/getter
   [resources/store store]
   (fn [resources store]
     (resources/resources resources (get store key)))))

(def country-list
  "The getter for country list."
  (resource-list welcome/store :countries))

(def region-list
  "The getter for region list."
  (resource-list welcome/store :regions))

(def spot-list
  "The getter for the spot list."
  (resource-list welcome/store :spots))

(def page
  "The getter for the welcome page."
  (coolant/getter
   [layout
    welcome/store
    country-list
    region-list
    spot-list]
   (fn [layout page countries regions spots]
     (merge layout page
            {:countries countries
             :regions regions
             :spots spots}))))
