(ns burningswell.web.stores.spot
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]
            [no.en.core :refer [deep-merge]]))

(defn spots-path [spot]
  (concat (resources/spot-path spot) [:spots]))

(defn photos-path [photo]
  (concat (resources/spot-path photo) [:photos]))

(defn update-spot
  "Update the current spot."
  [state spot]
  (assoc state :spot (resources/spot-path spot)))

(defn update-spots
  "Update the `spots` around a `spot`."
  [state [spot spots]]
  (assoc-in state (spots-path spot) (map resources/spot-path spots)))

(defn update-photos
  "Update the `photos` of a `spot`."
  [state [spot photos]]
  (assoc-in state (photos-path spot) (map resources/photo-path photos)))

(def store
  "The spots page store."
  (coolant/store
   :spot
   {:spot nil}
   {:spot/spot update-spot
    :spot/photos update-photos
    :spot/spots update-spots}))
