(ns burningswell.web.components.weather-table
  (:require-macros [cljs.core.async.macros :refer [go]]
                   [sablono.core :refer [defhtml html]])
  (:require [burningswell.web.util :refer [size-of]]
            [burningswell.web.components.weather-summary :refer [->weather-summary]]
            [burningswell.web.components.wave-heights-chart :refer [->wave-height-chart]]
            [burningswell.web.time :as time]
            [cljs.core.async :refer [put! <! chan close! sliding-buffer]]
            [goog.format :as format]
            [hal.core :as hal]
            [om.core :as om :include-macros true]
            [om-tools.core :refer-macros [defcomponentk]]
            [request.core :as http]
            [sablono.core :as html]))

(defn format-number [n & [decimals]]
  (format/numericValueToString n decimals))

(defn variable [record name & [decimals]]
  (let [{:keys [value unit]} (get record name)]
    [:span {:class name}
     [:span.value (format-number value decimals)] " "
     [:span.unit unit]]))

(defn direction [degree]
  (let [directions ["North" "N/E" "East" "S/E" "South" "S/W" "West"]
        idx (mod (long (/ degree 45)) (count directions))]
    (nth directions idx)))

(defn select-weather-time [weather time time-zone]
  (->> (filter #(>= % time) (sort (keys weather)))
       ;; (filter #(time/day-time? % time-zone))
       ))

(defcomponentk weather-table
  [[:data time weather time-zone] owner opts]
  (render [_]
    (let [class (:class opts)
          timestamps (take 6 (select-weather-time weather time time-zone))
          time-zone (time/zone-by-offset (:offset time-zone))]
      (when-not (empty? timestamps)
        (html
         [:div {:class class}
          [:table {:class (str class "__table")}
           [:thead
            [:tr
             [:th.time
              [:iron-icon {:icon "schedule"}] "Time"]

             [:th.wave {:col-span 3}
              [:iron-icon {:icon "av:equalizer"}] "Waves"]

             [:th.wind {:col-span 2}
              [:iron-icon {:icon "flag"}] "Wind"]

             [:th.temp "Temp."]]]
           [:tbody
            (for [timestamp timestamps :let [record (get weather timestamp)]]
              [:tr {:key (.getTime timestamp)}
               [:td.time
                [:div {:class (str class "__time")}
                 (.format time/time-pattern timestamp time-zone)]
                [:div {:class (str class "__date")}
                 (.format time/date-pattern timestamp time-zone)]]

               [:td.wave
                [:div {:class (str class "__wave-height-value")}
                 (variable record :htsgwsfc 1)]
                [:div {:class (str class "__wave-height-description")}
                 "Height"]]

               [:td.perpwsfc
                [:div {:class (str class "__wave-period-value")}
                 (variable record :perpwsfc)]
                [:div {:class (str class "__wave-period-description")}
                 "Period"]]

               [:td.perpwsfc
                [:div {:class (str class "__wave-direction-value")}
                 (direction (-> record :dirpwsfc :value))]
                [:div {:class (str class "__wave-direction-description")}
                 "Direction"]]

               [:td.windsfc
                [:div {:class (str class "__wind-speed-value")}
                 (variable record :windsfc)]
                [:div {:class (str class "__wind-speed-description")}
                 "Speed"]]

               [:td.wdirsfc
                [:div {:class (str class "__wind-direction-value")}
                 (direction (-> record :wdirsfc :value))]
                [:div {:class (str class "__wind-direction-description")}
                 "Direction"]]

               [:td.temp
                [:div {:class (str class "__temperature-value")}
                 (int (-> record :tmpsfc :value))
                 " °" (-> record :tmpsfc :unit)]
                [:div {:class (str class "__temperature-description")}
                 "Air Temp."]]])]]
          [:div {:class (str class "__time-zone-info")}
           (if time-zone
             (str "Time is shown in the surf spot's local time zone, "
                  (.getLongName time-zone time))) "."]])))))

;; (defcomponentk bar-chart
;;   "Return a wave height bar chart component."
;;   [data owner opts]
;;   (did-mount [this]
;;     (let [node (om/get-node owner)]
;;       (om/set-state! owner :size (size-of node))))
;;   (render [this]
;;     (let [{:keys [chan variable]} (om/get-state owner)]
;;       (html
;;        [:div.bar-chart
;;         (let [timestamps (sort (keys data))
;;               variable (or variable :htsgwsfc)
;;               values (map #(get-in data [%1 variable :value]) timestamps)
;;               max-value (apply max (remove nil? values))
;;               size (om/get-state owner :size)
;;               max-width (or (:width size) 220)
;;               max-height (or (:height size) 20)
;;               padding 0.8
;;               width (/ (- max-width (* (count values) padding)) (count values))]
;;           [:svg {:width max-width :height max-height}
;;            [:g
;;             (map-indexed
;;              (fn [index timestamp]
;;                (let [{:keys [value unit]} (get-in data [timestamp variable])
;;                      value (js/Math.abs value) ;; TODO: WTF?
;;                      height (/ (* max-height value) max-value)
;;                      height (if (= js/isNaN height) 0 height)
;;                      hours (.getHours timestamp)
;;                      class (if (and (>= hours 5) (<= hours 22)) "day" "night")]
;;                  [:g.bar-mini
;;                   {:class class :transform (str "translate(" (* index (+ padding width)) ",0)")}
;;                   [:rect {:width width
;;                           :height height
;;                           :on-mouse-enter #(put! chan timestamp)
;;                           :y (- max-height height)}]]))
;;              timestamps)]])]))))
