(ns burningswell.web.mixins.center-vertical
  (:require [goog.style :as style]
            [om-tools.mixin :refer-macros [defmixin]]
            [om.core :as om :include-macros true]))

(defn center-element [owner]
  (let [element (om/get-node owner)
        size (style/getSize element)
        margin-left (* (/ (.-width size) 2) -1)
        margin-top (* (/ (.-height size) 2) -1)
        opts (om/get-state owner :center-vertical)]
    (style/setStyle element "left" "50%")
    (style/setStyle element "margin-left" (str margin-left "px"))
    (style/setStyle element "margin-top" (str margin-top "px"))
    (style/setStyle element "position" "absolute")
    (style/setStyle element "top" (str (or (:top opts) 50) "%"))))

(defmixin center-vertical
  (did-mount [owner]
    (center-element owner))
  (did-update [owner _ _]
    (center-element owner)))
