(ns burningswell.web.schemas
  (:require [geo.core :refer [Point]]
            [schema.core :as s :include-macros true]))

(defn add-created-at
  "Assoc the :created-at timestamp to `schema`."
  [schema]
  (assoc schema :created-at s/Inst))

(defn add-updated-at
  "Assoc the :updated-at timestamp to `schema`."
  [schema]
  (assoc schema :updated-at s/Inst))

(defn add-timestamps
  "Assoc the :created-at and :updated-at timestamps to `schema`."
  [schema]
  (-> (add-created-at schema)
      (add-updated-at)))

(defn add-hal-embedded
  "Assoc the :embedded HAL resources to `schema`."
  [schema]
  (assoc schema (s/optional-key :_embedded) s/Any))

(defn add-hal-links
  "Assoc the HAL :links to `schema`."
  [schema]
  (assoc schema (s/optional-key :_links) s/Any))

(s/defschema Location
  "Schema for a location."
  s/Any)

(s/defschema Country
  "Schema for a country."
  (-> {:_embedded s/Any
       :airport-count s/Int
       :area (s/maybe s/Int)
       :fips-code (s/maybe s/Str)
       :id s/Int
       :iso-3166-1-alpha-2 s/Str
       :iso-3166-1-alpha-3 s/Str
       :iso-3166-1-numeric s/Int
       :location s/Any ;; sometimes a cursor
       :name s/Str
       :phone-prefix (s/maybe s/Str)
       :population s/Int
       :port-count s/Int
       :region-count s/Int
       :spot-count s/Int
       :user-count s/Int}
      (add-hal-links)
      (add-timestamps)))

(s/defschema Spot
  "Schema for a spot."
  (-> {:_embedded s/Any
       :id s/Int
       :location s/Any ;; sometimes a cursor
       :name s/Str
       :visible s/Any}
      (add-hal-links)
      (add-timestamps)))

(s/defschema Region
  "Schema for a region."
  s/Any)
