(ns burningswell.web.components.weather
  (:require [burningswell.web.components.wave-heights-chart :refer [->wave-height-chart]]
            [burningswell.web.components.weather-summary :refer [->weather-summary]]
            [hal.core :as hal]
            [om.core :as om :include-macros true]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :refer-macros [html]]))

(defn on-time-change
  "Handle time changes via mouse/touch event."
  [owner time]
  (when-let [handler (om/get-state owner :on-time-change)]
    (handler time)))

(defn weather-summary
  "Render the weather summary."
  [owner time weather time-zone]
  (let [{:keys [class on-rating]} (om/get-state owner)
        time (or time (first (keys weather)))]
    (->weather-summary
     {:time time
      :weather (get weather time)
      :time-zone time-zone}
     {:opts
      {:class (str class "__summary")
       :on-rating on-rating}})))

(defn wave-heights-chart
  "Render the wave heights chart."
  [owner wave-heights]
  (let [class (om/get-state owner :class)]
    (->wave-height-chart
     wave-heights
     {:opts
      {:class (str class "__chart")
       :on-select #(on-time-change owner %)}})))

(defcomponentk weather
  "The weather component."
  [[:data time weather wave-heights time-zone] owner state opts]
  (init-state [_]
    {:class (or (:class opts) "weather")
     :on-rating (:on-rating opts)
     :on-time-change (:on-time-change opts)})
  (render [_]
    (let [class (:class @state)]
      (if (empty? weather)
        (html
         [:div {:class (:class @state)}
          "No surf forecast available."])
        (html
         [:div {:class class}
          (weather-summary owner time weather time-zone)
          (wave-heights-chart owner wave-heights)])))))
