(ns burningswell.web.ui.spot-headline
  (:require [burningswell.web.ui.links :as link-to]
            [burningswell.web.util :as util]
            [hal.core :as hal]
            [rum.core :as rum]
            [rum.mdl :as mdl]))

(rum/defc spot-headline < rum/static
  "Render the spot headline."
  [system spot]
  (when (:name spot)
    [:div.spot-headline
     [:h6.spot-headline__name
      [:img.spot-headline__country-flag
       {:src (util/country-flag-url (hal/embedded spot :country))}]
      (link-to/spot system spot)]
     [:div.spot-headline__location
      (mdl/icon {:class "spot-headline__location-icon"} "location_on")
      (link-to/region system (hal/embedded spot :region))
      ", "
      (link-to/country system (hal/embedded spot :country))]]))
