(ns burningswell.web.modules.country
  (:require [burningswell.web.coolant :as coolant]
            [burningswell.web.getter.country :as country]
            [burningswell.web.modules.core :refer [module-loaded render-server]]
            [burningswell.web.ui.layout :refer [layout]]
            [burningswell.web.ui.region-list :refer [region-list]]
            [rum.core :as rum]))

(rum/defc content < rum/static
  "Render the content of the country page."
  [system {:keys [country regions] :as page}]
  (layout
   system page
   [:div.country__content
    (region-list system regions)]))

(rum/defcs page < (coolant/mixin country/page)
  "Render the country page."
  [page system]
  (content system page))

(defmethod render-server :country [system]
  #?(:clj (->> (coolant/get system country/page)
               (content system)
               (rum/render-html))))

(def ^:export main page)
(module-loaded :country)
