(ns burningswell.web.webdriver
  (:require [com.stuartsierra.component :as component]
            [clj-webdriver.driver :as driver]
            [clj-webdriver.core :as core]
            [clj-webdriver.taxi :as taxi])
  (:import [clj_webdriver.driver Driver]))

(def ^:dynamic *driver* nil)

(defn quick-fill [driver & query-action-maps]
  (binding [taxi/*driver* driver]
    (doall (apply taxi/quick-fill query-action-maps))))

(defn new-webdriver
  "Return a new web driver."
  [browser-spec]
  (driver/map->Driver {:browser-spec browser-spec}))

(extend-type Driver
  component/Lifecycle
  (start [driver]
    (if *driver*
      *driver*
      (let [spec (:browser-spec driver)
            driver (core/new-driver spec)]
        (taxi/implicit-wait driver (* 1000 10))
        (alter-var-root #'*driver* (constantly driver))
        driver)))
  (stop [driver]
    driver))
