(ns apollo.core
  (:require [clojure.java.io :as io]
            [clojure.spec.alpha :as s]
            [grafiko.lang.core :as grafiko]))

(defmacro defgql [name doc]
  `(def ~name
     (let [doc# ~doc]
       (try
         (cljs.core/clj->js (grafiko.lang.core/parse-document-js doc#))
         (catch js/Error e#
           (println "Invalid GraphQL document:")
           (prn doc#)
           ;; TODO: Explain problems
           (throw e#))))))

(defmacro resource
  "Returns a JavaScript AST for the GraphQL document at the resource `path`."
  [path]
  (when-let [content (some-> path io/resource slurp)]
    `(apollo.core/gql ~content)))

(defmacro with-mutation
  [bindings params & body]
  `(apollo.core/mutation
    ~params
    (fn [action# props#]
      (let [[~@bindings] [action# props#]]
        ~@body))))

(defmacro with-query
  [bindings params & body]
  `(apollo.core/query
    ~params
    (fn [props#]
      (let [~@bindings props#]
        ~@body))))
