(ns burningswell.web.main
  (:require [burningswell.web.core :as core]
            [burningswell.web.router :as router]
            [burningswell.web.system :as system]
            [burningswell.web.ui.app-bar :as app-bar]
            [burningswell.web.ui.drawer :as drawer]
            [burningswell.web.ui.system :as system-ui]
            [burningswell.web.ui.pages :as pages]
            [react-dom :refer [hydrate]]
            [sablono.core :refer [html]]))

(defonce +config+ nil)

(defmulti page
  (fn [route] (-> route :handler keyword)))

(defmethod page :home [route]
  ((resolve 'burningswell.web.pages.home/main) route))

(defmethod page :continent [route]
  ((resolve 'burningswell.web.pages.continent/main) route))

(defmethod page :continents [route]
  ((resolve 'burningswell.web.pages.continents/main) route))

(defmethod page :countries [route]
  ((resolve 'burningswell.web.pages.countries/main) route))

(defmethod page :country [route]
  ((resolve 'burningswell.web.pages.country/main) route))

(defmethod page :reset-password [route]
  ((resolve 'burningswell.web.pages.reset-password/main) route))

(defmethod page :map [route]
  ((resolve 'burningswell.web.pages.map/main) route))

(defmethod page :region [route]
  ((resolve 'burningswell.web.pages.region/main) route))

(defmethod page :regions [route]
  ((resolve 'burningswell.web.pages.regions/main) route))

(defmethod page :search [route]
  ((resolve 'burningswell.web.pages.search/main) route))

(defmethod page :spot [route]
  ((resolve 'burningswell.web.pages.spot/main) route))

(defmethod page :spots [route]
  ((resolve 'burningswell.web.pages.spots/main) route))

(defmethod page :signin [route]
  ((resolve 'burningswell.web.pages.signin/main) route))

(defmethod page :signup [route]
  ((resolve 'burningswell.web.pages.signup/main) route))

(defmethod page :user [route]
  ((resolve 'burningswell.web.pages.user/main) route))

(defmethod page :users [route]
  ((resolve 'burningswell.web.pages.users/main) route))

(defn shell [route]
  (pages/page {:name "shell" :title "Shell"}))

(defn root []
  (router/route-consumer
   (fn [{:keys [handler loaded] :as route}]
     (if (and handler loaded)
       (page route)
       (shell route)))
   {:key "root"}))

(defn- app-element [system]
  (.getElementById js/document "app"))

(defn view [system route]
  (system-ui/provider
   system
   (core/apollo-provider
    {:client (:client system)
     :key "apollo-provider"}
    (root))))

(defn stop
  "Stop the Burning Swell web application."
  []
  (system/stop!))

(defn ^{:export true} start
  "Start the Burning Swell web application."
  []
  (let [{:keys [router] :as system} (system/start! +config+)
        route (router/match-current-url! router)]
    (hydrate (view system route) (app-element system))))

(defn ^{:export true} main
  [config]
  (set! +config+ (js->clj config :keywordize-keys true))
  (start))
