(ns burningswell.web.pages.region
  (:require [apollo.core :as a]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.links :as links]
            [burningswell.web.ui.lists :as lists]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(a/defgql region-query
  '((query
     region
     [($slug String)]
     ((region node)
      [(slug $slug)]
      (... region)))
    (fragment
     region (on Region)
     id name
     (country
      id name
      (continent
       id name
       (slug path))
      (slug path))
     (slug path))))

(defn main [route]
  (a/query
   {:query region-query
    :variables {:slug (:uri route)}}
   (fn [{:keys [client data error loading]}]
     (pages/page
      {:name "region"
       :title (-> data :region :name)}
      (cond
        error
        [:div "Error :("]
        loading
        [:div "Loading ..."]
        :else
        (let [{:keys [region]} data
              country (:country region)]
          (layout/grid
           {}
           (layout/row
            {}
            (layout/cell
             {:columns 12}
             [:h1.mdc-typography--headline5 (:name region)]
             (links/country country)
             (links/continent (:continent country))
             (lists/spots {:regions [(:id region)]}))))))))))

(when (exists? js/window)
  (loader/set-loaded! :region))
