(ns burningswell.web.pages.user
  (:require [apollo.core :as a]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.core :as core]
            [burningswell.web.ui.links :as links]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(a/defgql user-query
  '((query
     user
     [($slug String)]
     ((user node)
      [(slug $slug)]
      (... user)))
    (fragment
     user (on User)
     id
     first_name
     last_name
     username
     (country
      id name
      (slug path))
     (region
      id name
      (slug path))
     (slug path))))

(defn main [route]
  (a/query
   {:query user-query
    :variables {:slug (:uri route)}}
   (fn [{:keys [client data error loading]}]
     (pages/page
      {:name "user"
       :title (core/user-name (:user data))}
      (cond
        error
        [:div "Error :("]
        loading
        [:div "Loading ..."]
        :else
        (let [{:keys [user]} data]
          (layout/grid
           {}
           (layout/row
            {}
            (layout/cell
             {:columns 12}
             [:h1.mdc-typography--headline5 (core/user-name user)]
             (links/region (:region user))
             (links/country (:country user)))))))))))

(when (exists? js/window)
  (loader/set-loaded! :user))
