(ns burningswell.web.server.http
  (:require [burningswell.web.logging :as log]
            [burningswell.web.server.middleware :refer [wrap-defaults]]
            [burningswell.web.server.routes :refer [router]]
            [com.stuartsierra.component :as component]
            [macchiato.server :as http]))

(def logger
  "The logger of the current namespace."
  (log/logger (namespace ::logger)))

(defrecord Http [bind-address bind-port handler]
  component/Lifecycle
  (start [service]
    (if handler
      service
      (->> (http/start
            {:cookies {:signed? false}
             :handler (wrap-defaults (router service))
             :host bind-address
             :on-success #(log/info logger "HTTP server started.")
             :port bind-port})
           (assoc service :handler))))

  (stop [service]
    (some-> handler (.close #(log/info logger "HTTP server stopped.")))
    (assoc service :handler nil)))

(defn http
  "Returns a new HTTP component for `config`."
  [& [config]]
  (component/using (map->Http config) [:config :logging]))
