(ns burningswell.web.session
  (:require [burningswell.web.logging :as log]
            [com.stuartsierra.component :as component]))

(def logger
  "The logger of the current namespace."
  (log/logger (namespace ::logger)))

(defn create-session!
  "Create a new session."
  [{:keys [session-storage]}]
  (let [session-id (random-uuid)]
    (assoc! session-storage :session-id session-id)
    (log/info logger (str "Created new session: " session-id))
    session-id))

(defn session-id
  "Returns the current session id."
  [{:keys [session-storage]}]
  (get session-storage :session-id))

(defrecord Session [session-storage]
  component/Lifecycle
  (start [service]
    (when-not (session-id service)
      (create-session! service))
    (log/info logger "Session started.")
    service)
  (stop [service]
    (log/info logger "Session stopped.")
    service))

(defn session
  "Returns a new session component."
  []
  (-> (map->Session {})
      (component/using [:session-storage])))
