(ns burningswell.web.ui.app-bar
  (:require ["@material/react-top-app-bar" :default TopAppBar :refer [TopAppBarFixedAdjust]]
            [apollo.core :as a]
            [burningswell.web.ui.icon :refer [icon]]
            [burningswell.web.ui.system :as system]
            [burningswell.web.ui.viewer :as viewer]
            [react :as React :refer [createElement]]))

(a/defgql drawer-query
  '((drawer ((client)) open)))

(defn top-app-bar [& [opts]]
  (createElement TopAppBar (clj->js opts)))

(defn top-app-bar-fixed-adjust [& children]
  (createElement TopAppBarFixedAdjust #js {:children children}))

(defn- toggle-drawer! [client]
  (let [state (a/read-query client drawer-query)]
    (->> (update-in state [:drawer :open] not)
         (a/write-data! client))))

(defn- navigation-icon [client]
  (icon :menu {:on-click #(toggle-drawer! client)}))

(defn app-bar [& [{:keys [key title navigation?]}]]
  (system/consumer
   (fn [{:keys [client]}]
     (top-app-bar
      {:actionItems
       [(icon :search)
        (icon :more_vert)
        (viewer/profile-photo)]
       :key key
       :navigationIcon (when navigation? (navigation-icon client))
       :title title}))
   {:key (str key "-consumer")}))
