(ns burningswell.web.ui.auto-complete.countries
  (:require [burningswell.web.ui.icon :refer [icon]]
            [burningswell.web.ui.util :as util]
            [sablono.core :refer [html]]))

(def fragment
  "The auto complete fragment for a country."
  '(fragment
    country (on Country)
    id iso-3166-1-alpha-2 name region-count spot-count
    (continent id name)
    (slug path)))

(defn suggestion
  "Render the auto complete suggestion for a country."
  [{:keys [continent] :as country}]
  (html
   [:div.auto-complete-result.auto-complete-result--country
    {:key (str "auto-complete-result-" (:id country))}
    [:div.auto-complete-result__icon {}
     (icon "terrain")]
    [:div.auto-complete-result__title {}
     (util/country-flag country)
     (:name country)]
    [:div.auto-complete-result__subtitle {}
     (:name continent)]
    [:div.auto-complete-result__details {}
     (util/pluralize (:region_count country) "region") ", "
     (util/pluralize (:spot_count country) "spot")]]))
