(ns burningswell.web.ui.auto-complete.spots
  (:require [burningswell.web.ui.icon :refer [icon]]
            [burningswell.web.ui.util :as util]
            [sablono.core :refer [html]]))

(def fragment
  "The auto complete fragment for a spot."
  '(fragment
    spot (on Spot)
    id name
    (country id name iso-3166-1-alpha-2)
    (region id name)
    (slug path)))

(defn suggestion
  "Render the auto complete suggestion for a spot."
  [{:keys [country region] :as spot}]
  (html
   [:div.auto-complete-result.auto-complete-result--spot {}
    [:div.auto-complete-result__icon {}
     (icon "location_on")]
    [:div.auto-complete-result__title {}
     (util/country-flag country)
     (:name spot)]
    [:div.auto-complete-result__subtitle {}
     (if region (:name region))
     (if region ", ")
     (:name country) ", "
     (-> country :continent :name)]]))
