(ns burningswell.web.ui.viewer
  (:require [apollo.core :as a]
            [sablono.core :refer [html]]))

(defn- profile-photo-url [viewer]
  (-> viewer :user
      (a/nodes :profile_photos)
      first
      (a/nodes :images)
      first :url))

(defn profile-photo []
  (a/with-query [{:keys [data loading]}]
    {:query
     (a/ast '((viewer
               (user
                id
                (profile_photos
                 (edges
                  (node
                   id
                   (images
                    [(first 1)
                     (sort WIDTH)]
                    (edges (node id url))))))))))}
    (when-let [url (profile-photo-url (:viewer data))]
      (html [:div.viewer-profile-photo
             [:img.viewer-profile-photo__image
              {:src url}]]))))
