(ns burningswell.web.pages.reset-password
  (:require [apollo.core :as a]
            [burningswell.web.authentication :as auth]
            [burningswell.web.ui.forms.reset-password :as reset-password]
            [burningswell.web.router :as router]
            [burningswell.web.ui.pages :as pages]
            [burningswell.web.ui.system :as system]
            [cljs.loader :as loader]
            [sablono.core :refer [html]]))

(defn on-reset-password
  [{:keys [authentication client router]} result]
  (some->> (-> result :reset-password :auth_token)
           (auth/save-auth-token! authentication))
  (a/reset-store! client)
  (router/to! router :home))

(defn main []
  (system/with-consumer [system]
    (pages/page
     {:name "reset-password"
      :title "Reset Password"}
     (html
      [:div
       [:h1.mdc-typography--headline5
        "Reset Your Password?"]
       [:div.reset-password-page__description
        "Enter your email address and we will send you a link to reset
        your password."]
       (reset-password/form
        {:id "reset-password-page"
         :on-reset-password #(on-reset-password system %)})]))))

(when (exists? js/window)
  (loader/set-loaded! :reset-password))
