(ns burningswell.web.pages.search
  (:require [apollo.core :as a]
            [burningswell.web.ui.auto-complete :refer [auto-complete]]
            [burningswell.web.ui.layout :as layout]
            [burningswell.web.ui.lists :as lists]
            [burningswell.web.ui.pages :as pages]
            [cljs.loader :as loader]))

(defn main []
  (a/with-query [{:keys [data]}]
    {:query (a/ast '((location ((client)) latitude longitude)))}
    (let [location (:location data)]
      (pages/page
       {:name "search"
        :title "Search"}
       (layout/grid
        {}
        (layout/row
         {}
         "Search"))))))

(when (exists? js/window)
  (loader/set-loaded! :search))
