(ns burningswell.web.pages.signin
  (:require [apollo.core :as a]
            [burningswell.web.authentication :as auth]
            [burningswell.web.router :as router]
            [burningswell.web.ui.forms.signin :refer [signin-form]]
            [burningswell.web.ui.pages :as pages]
            [burningswell.web.ui.system :as system]
            [cljs.loader :as loader]
            [sablono.core :refer [html]]))

(defn on-signin
  [{:keys [authentication client router]} result]
  (some->> (-> result :signin :auth_token)
           (auth/save-auth-token! authentication))
  (a/reset-store! client)
  (router/to! router :home))

(defn main []
  (system/with-consumer [system]
    (pages/page
     {:name "signin"
      :title "Signin"}
     (html
      [:div
       [:h1.mdc-typography--headline5
        "Signin"]
       (signin-form
        {:id "signin-page"
         :on-signin #(on-signin system %)})]))))

(when (exists? js/window)
  (loader/set-loaded! :signin))
