(ns burningswell.web.ui.system
  (:require [react :as React :refer [createContext createElement]])
  (:require-macros [burningswell.web.ui.system :refer [with-consumer]]))

(def context
  "The React system context."
  (createContext nil))

(defn provider
  "Returns a React system provider element."
  [system & children]
  (createElement
   (.-Provider context)
   #js {:children children
        :value system}))

(defn consumer
  "Returns a React system consumer element."
  [render-fn & [opts]]
  (createElement
   (.-Consumer context)
   (clj->js (assoc opts :children #(render-fn %)))))
