(ns burningswell.web.ui.util
  (:require [clojure.string :as str]
            [sablono.core :refer [defhtml]]))

(defn country-flag-url
  "Return the URL of the `country` flag."
  [country]
  (when-let [code (:iso_3166_1_alpha_2 country)]
    (str "/images/countries/flags/4x3/" (str/lower-case code) ".svg")))

(defhtml country-flag
  "Render the `country` flag image."
  [country]
  (when-let [url (country-flag-url country)]
    [:img.country-flag {:src url}]))

(defhtml pluralize
  "Returns `singular` if `count` is 1, otherwise `plural`."
  [count singular & [plural]]
  [:span.pluralize
   [:span.pluralize__count count]
   " "
   [:span.pluralize__term
    (if (= count 1)
      singular
      (or plural (str singular "s")))]])
