(ns burningswell.web.logging
  (:require [com.stuartsierra.component :as component]
            [goog.log :as log])
  (:import [goog.debug Console LogManager]
           [goog.debug.Logger Level]))

(def default-level
  "The default log level."
  Level.INFO)

(defrecord Logging [level reporter]
  component/Lifecycle
  (start [this]
    (let [reporter (goog.debug.Console.)]
      (.setCapturing reporter true)
      (.setLevel (.getRoot LogManager) level)
      (assoc this :reporter reporter)))
  (stop [this]
    (.setCapturing reporter false)
    (assoc this :reporter nil)))

(defn logging
  "Returns a logging component."
  [& [{:keys [level] :as config}]]
  (map->Logging (merge {:level default-level} config)))

(defn logger
  "Return the logger for `name`."
  [name]
  (when ^boolean goog.DEBUG (log/getLogger name)))

(defn debug
  "Log `message` at debug level using `logger`."
  [logger message]
  (when ^boolean goog.DEBUG (log/fine logger message)))

(defn error
  "Log `message` at error level using `logger`."
  [logger message]
  (when ^boolean goog.DEBUG (log/error logger message)))

(defn info
  "Log `message` at info level using `logger`."
  [logger message]
  (when ^boolean goog.DEBUG (log/info logger message)))

(defn warning
  "Log `message` at warning level using `logger`."
  [logger message]
  (when ^boolean goog.DEBUG (log/warning logger message)))
